<!-- Enhanced Medical Lab Analysis CTA Section -->
<div class="container-fluid px-3 px-md-4 py-4">
    <div class="row justify-content-center">
        <div class="col-12 col-lg-10 col-xl-8">
            <!-- Main CTA Card -->
            <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
                <!-- Gradient Background -->
                <div class="card-body p-0" style="background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);">
                    <div class="row g-0 align-items-center min-vh-20">
                        <!-- WhatsApp Action Column -->
                        <div class="col-12 col-md-4 col-lg-3 text-center py-4 py-md-5">
                            <div class="d-flex flex-column align-items-center">
                                <!-- WhatsApp Button -->
                                <a href="https://wa.me/+923158274326"
                                   target="_blank"
                                   class="whatsapp-btn btn btn-success rounded-circle p-3 mb-3 position-relative"
                                   style="width: 80px; height: 80px; display: flex; align-items: center; justify-content: center; box-shadow: 0 8px 25px rgba(37, 211, 102, 0.3); transition: all 0.3s ease;">
                                    <i class="fab fa-whatsapp" style="font-size: 2.5rem;"></i>
                                    <!-- Pulse Animation -->
                                    <span class="position-absolute top-0 start-0 w-100 h-100 rounded-circle"
                                          style="background: rgba(37, 211, 102, 0.3); animation: pulse 2s infinite;"></span>
                                </a>

                                <!-- Call to Action Text -->
                                <div class="text-center">
                                    <a href="https://wa.me/+923158274326"
                                       target="_blank"
                                       class="badge bg-light text-success px-3 py-2 rounded-pill mb-2 text-decoration-none">
                                        <i class="fas fa-phone-alt me-1"></i>
                                        Click to upload Report
                                    </a>
                                    <p class="text-light small mb-0 opacity-75">
                                        Available 24/7
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Content Column -->
                        <div class="col-12 col-md-8 col-lg-9 py-4 py-md-5 px-4 px-md-5">
                            <div class="text-white">
                                <!-- Main Heading -->
                                <div class="d-flex align-items-center mb-3">
                                    <i class="fas fa-user-md text-warning me-3" style="font-size: 1.8rem;"></i>
                                    <h3 class="h4 mb-0 fw-bold">Free Expert Medical Analysis</h3>
                                </div>

                                <!-- Description -->
                                <p class="lead mb-4 opacity-90" style="line-height: 1.6;">
                                    Get professional, expert-based analysis of your first medical lab report absolutely free.
                                    We help you understand your health results in simple, clear language.
                                </p>

                                <!-- Features List -->
                                <div class="row g-3 mb-4">
                                    <div class="col-12 col-sm-6">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-vial text-warning me-2"></i>
                                            <span class="small">Blood Tests</span>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-microscope text-warning me-2"></i>
                                            <span class="small">Urine Tests</span>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-x-ray text-warning me-2"></i>
                                            <span class="small">CT Scans</span>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-brain text-warning me-2"></i>
                                            <span class="small">MRI Reports</span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Trust Indicators -->
                                <div class="d-flex flex-wrap align-items-center gap-3 opacity-75">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-shield-alt text-success me-2"></i>
                                        <span class="small">100% Confidential</span>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-clock text-success me-2"></i>
                                        <span class="small">Quick Response</span>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-certificate text-success me-2"></i>
                                        <span class="small">Expert Analysis</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Additional Info Cards -->
            <div class="row g-3 mt-4">
                <div class="col-12 col-md-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body text-center p-4">
                            <i class="fas fa-user-md text-info mb-3" style="font-size: 2rem;"></i>
                            <h6 class="fw-bold mb-2">Expert Doctors</h6>
                            <p class="text-muted small mb-0">Qualified medical professionals review your reports</p>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body text-center p-4">
                            <i class="fas fa-language text-info mb-3" style="font-size: 2rem;"></i>
                            <h6 class="fw-bold mb-2">Simple Language</h6>
                            <p class="text-muted small mb-0">Complex medical terms explained in easy words</p>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body text-center p-4">
                            <i class="fas fa-lock text-info mb-3" style="font-size: 2rem;"></i>
                            <h6 class="fw-bold mb-2">Secure & Private</h6>
                            <p class="text-muted small mb-0">Your medical information is completely confidential</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS for animations and enhanced styling -->
<style>
    @keyframes pulse {
        0% {
            transform: scale(1);
            opacity: 1;
        }
        50% {
            transform: scale(1.1);
            opacity: 0.7;
        }
        100% {
            transform: scale(1);
            opacity: 1;
        }
    }

    .whatsapp-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 12px 35px rgba(37, 211, 102, 0.4) !important;
    }

    .card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .card:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12) !important;
    }

    .min-vh-20 {
        min-height: 20vh;
    }

    /* Mobile optimizations */
    @media (max-width: 768px) {
        .whatsapp-btn {
            width: 70px !important;
            height: 70px !important;
        }

        .whatsapp-btn i {
            font-size: 2rem !important;
        }

        .lead {
            font-size: 1.1rem !important;
        }
    }

    /* Ensure proper spacing on very small screens */
    @media (max-width: 576px) {
        .card-body .px-4 {
            padding-left: 1.5rem !important;
            padding-right: 1.5rem !important;
        }
    }

    /* Custom rounded corners for modern look */
    .rounded-4 {
        border-radius: 1rem !important;
    }

    /* Smooth transitions for interactive elements */
    .btn, .badge {
        transition: all 0.3s ease;
    }

    .badge:hover {
        transform: scale(1.05);
    }
</style>
